#include "TextWriter.h"
#include <stdarg.h>
#include <string.h>
#include <ctype.h>

CTextWriter::CTextWriter()
{
	Bitmap = new CBitmapParent(64, 64);
	WholeFont = Bitmap->GetResource("DizzyFont.png");
}

CTextWriter::~CTextWriter()
{
	delete WholeFont;
}

#ifdef WIN32
#define vsnprintf _vsnprintf
#endif

#define WriteStr()\
	char TempString[2048];\
	va_list args;\
	va_start(args, fmt);\
	vsnprintf(TempString, 2048, fmt, args);\
	va_end(args)

float CTextWriter::GetHeight(float x1, float x2, char *fmt, ...)
{
	WriteStr();
	int c = strlen(TempString);
	while(c--) TempString[c] = toupper(TempString[c]);
	Draw = false;
	WriteInternal(x1, 0, x2, 0, TempString);
	return MaxY*8.0f;
}

void CTextWriter::Write(float x1, float y1, float x2, float y2, char *fmt, ...)
{
	WriteStr();
	int c = strlen(TempString);
	while(c--) TempString[c] = toupper(TempString[c]);
	Draw = true;
	WriteInternal(x1, y1, x2, y2, TempString);
}

void CTextWriter::WriteInternal(float x1, float y1, float x2, float y2, char *TempString)
{
	unsigned int w, h;
	w = (int)(x2 - x1) >> 3;
	h = (int)(y2 - y1) >> 3;

	unsigned int x = 0, y = 0;
	
	char *cptr = TempString;

	if(Draw)
	{
		Bitmap->Activate();
		glPushMatrix();
			glTranslatef(x1, y1, 0);
	}

	MaxY = 1;
	while(*cptr)
	{
		/* chop off next word */
		char NextWord[64];
		char *copyptr = NextWord;

		while(*cptr != ' ' && *cptr != '\0')
		{
			*copyptr++ = *cptr;
			cptr++;
		}
		*copyptr = '\0';

		/* decide if it will fit on this line */
		if(x+strlen(NextWord) > w)
		{
			x = 0;
			y++;
			/* quit if the box is now full */
			if(Draw)
			{
				if(y == h) break;
			}
			else
				MaxY++;
		}

		/* now draw, starting at x, y, with a space on the end */
		if(Draw)
		{
			glPushMatrix();
				glTranslatef((float)(x << 3), (float)(y << 3), 0);
				copyptr = NextWord;
				while(*copyptr)
				{
					float x1, y1, x2, y2;
					x1 = ((*copyptr - 32)&7)*8.0f / 64.0f;
					x2 = x1 + 1.0f/8.0f;
					y1 = ((*copyptr - 32) >> 3)*8.0f / 64.0f;
					y2 = y1 + 1.0f/8.0f;

					glBegin(GL_QUADS);
						glTexCoord2f(x1, y1); glVertex2f(0, 0);
						glTexCoord2f(x2, y1); glVertex2f(8, 0);
						glTexCoord2f(x2, y2); glVertex2f(8, 8);
						glTexCoord2f(x1, y2); glVertex2f(0, 8);
					glEnd();
					glTranslatef(8, 0, 0);
					copyptr++;
				}
			glPopMatrix();
		}
		x+= strlen(NextWord)+1;

		/* skip spaces */
		while(*cptr == ' ' && *cptr != '\0')
			cptr++;
	}

	if(Draw)
		glPopMatrix();
}

float CTextWriter::GetLength(char *fmt, ...)
{
	WriteStr();
	return strlen(TempString) * 8.0f;
}
