#ifndef __SOUND_H
#define __SOUND_H

#include "dumb.h"
#include "SDL.h"

#define		SND_JUMP	0
#define		SND_TOTAL	1

class CSoundPlayer
{
	public:
		CSoundPlayer();
		~CSoundPlayer();

		void StartFile(char *name);
		void PlaySoundEffect(int ID);
	private:
		DUH *duh;
		DUH_SIGRENDERER *sr;
		static void AudioUpdateFunctionHelper(void *, Uint8 *, int);
		void AudioUpdateFunction(void *, Uint8 *, int);
		SDL_AudioSpec AudioSpec;

		Uint32 PlayOffset;
		struct Snd
		{
			Uint8 *Buffer;
			Uint32 Length;
		} Sounds[SND_TOTAL], *PlayPtr;
		void InstallSound(int slot, char *name);
};

extern CSoundPlayer *SoundPlayer;

#endif
