#include "Sound.h"
#include <stdio.h>
#include <string.h>
#include "Archive.h"

CSoundPlayer *SoundPlayer;
CSoundPlayer::CSoundPlayer()
{
	dumb_register_stdfiles();
	duh = NULL;
	int c = SND_TOTAL;
	while(c--)
		Sounds[c].Buffer = NULL;
	PlayPtr = NULL;
		
	/* init audio */
	SDL_AudioSpec WAudioSpec;

	WAudioSpec.freq = 44100;
	WAudioSpec.format = AUDIO_S16SYS;
	WAudioSpec.channels = 2;
	WAudioSpec.samples = 2048;
	WAudioSpec.callback = AudioUpdateFunctionHelper;
	WAudioSpec.userdata = this;

	if(SDL_OpenAudio(&WAudioSpec, &AudioSpec) >= 0)
	{
		SDL_PauseAudio(0);
		InstallSound(SND_JUMP, "jump.wav");
	}
}

CSoundPlayer::~CSoundPlayer()
{
	SDL_CloseAudio();
	if(duh)
	{
		duh_end_sigrenderer(sr);
		unload_duh(duh);
	}
	dumb_exit();

	int c = SND_TOTAL;
	while(c--)
		if(Sounds[c].Buffer)
		{
			free(Sounds[c].Buffer);
			Sounds[c].Buffer = NULL;
		}
}

int sdl_skip(void *f, long n)
{
	int curpos = ((SDL_RWops *)f)->seek((SDL_RWops *)f, 0, SEEK_CUR);
	int newpos = ((SDL_RWops *)f)->seek((SDL_RWops *)f, n, SEEK_CUR);
	return newpos - curpos - n;
}

int sdl_getc(void *f)
{
	Uint8 res;
	if(((SDL_RWops *)f)->read((SDL_RWops *)f, &res, 1, 1) != 1) return -1;
	return res;
}

long sdl_getnc(char *ptr, long n, void *f)
{
	return ((SDL_RWops *)f)->read((SDL_RWops *)f, ptr, 1, n);
}

void sdl_close(void *f)
{
}

static DUMBFILE_SYSTEM sdlrwops_dfs = {
	NULL,
	&sdl_skip,
	&sdl_getc,
	&sdl_getnc,
	&sdl_close
};

DUMBFILE *dumbfile_convertRW(SDL_RWops *ops)
{
       return dumbfile_open_ex((void *)ops, &sdlrwops_dfs);
}

DUH *dumb_read_it_RW(SDL_RWops *f)	{ DUMBFILE *NewF = dumbfile_convertRW(f); DUH *res = dumb_read_it(NewF); dumbfile_close(NewF); return res; }
DUH *dumb_read_xm_RW(SDL_RWops *f)	{ DUMBFILE *NewF = dumbfile_convertRW(f); DUH *res = dumb_read_xm(NewF); dumbfile_close(NewF); return res; }
DUH *dumb_read_s3m_RW(SDL_RWops *f)	{ DUMBFILE *NewF = dumbfile_convertRW(f); DUH *res = dumb_read_s3m(NewF); dumbfile_close(NewF); return res; }
DUH *dumb_read_mod_RW(SDL_RWops *f)	{ DUMBFILE *NewF = dumbfile_convertRW(f); DUH *res = dumb_read_mod(NewF); dumbfile_close(NewF); return res; }
DUH *dumb_read_it_quick_RW(SDL_RWops *f)	{ DUMBFILE *NewF = dumbfile_convertRW(f); DUH *res = dumb_read_it_quick(NewF); dumbfile_close(NewF); return res; }
DUH *dumb_read_xm_quick_RW(SDL_RWops *f)	{ DUMBFILE *NewF = dumbfile_convertRW(f); DUH *res = dumb_read_xm_quick(NewF); dumbfile_close(NewF); return res; }
DUH *dumb_read_s3m_quick_RW(SDL_RWops *f)	{ DUMBFILE *NewF = dumbfile_convertRW(f); DUH *res = dumb_read_s3m_quick(NewF); dumbfile_close(NewF); return res; }
DUH *dumb_read_mod_quick_RW(SDL_RWops *f)	{ DUMBFILE *NewF = dumbfile_convertRW(f); DUH *res = dumb_read_mod_quick(NewF); dumbfile_close(NewF); return res; }

void CSoundPlayer::StartFile(char *name)
{
	SDL_RWops *t = FileStore.GetRWops(name);
	duh = dumb_read_mod_RW(t);
	FileStore.ReturnRWops(t);

	sr = duh_start_sigrenderer(duh, 0, AudioSpec.channels, 0);
}

void CSoundPlayer::AudioUpdateFunctionHelper(void *tptr, Uint8 *TargetBuffer, int TargetLength)
{
	((CSoundPlayer *)tptr)->AudioUpdateFunction(NULL, TargetBuffer, TargetLength);
}

void CSoundPlayer::AudioUpdateFunction(void *tptr, Uint8 *TargetBuffer, int TargetLength)
{
	if(duh)
	{
		switch(AudioSpec.format)
		{
			case AUDIO_U16SYS:
				duh_render(sr, 16, 1, 1.0f, 65536.0f / AudioSpec.freq, TargetLength >> AudioSpec.channels, TargetBuffer);
			break;
			case AUDIO_U8:
				duh_render(sr, 8, 1, 1.0f, 65536.0f / AudioSpec.freq, TargetLength >> (AudioSpec.channels-1), TargetBuffer);
			break;
			case AUDIO_S8:
				duh_render(sr, 8, 0, 1.0f, 65536.0f / AudioSpec.freq, TargetLength >> (AudioSpec.channels-1), TargetBuffer);
			break;
			case AUDIO_S16SYS:
				duh_render(sr, 16, 0, 1.0f, 65536.0f / AudioSpec.freq, TargetLength >> AudioSpec.channels, TargetBuffer);
			break;
		}
	}
	else
	{
		memset(TargetBuffer, 0, TargetLength);
	}

	if(PlayPtr)
	{
		if((AudioSpec.format == AUDIO_S16SYS) || (AudioSpec.format == AUDIO_U16SYS))
		{
			unsigned int CopyEnd = TargetLength >> 1;
			if(CopyEnd > (PlayPtr->Length >> 1)-PlayOffset)
				CopyEnd = (PlayPtr->Length >> 1)-PlayOffset;

			for(unsigned int c = 0; c < CopyEnd; c++)
				((Uint16 *)TargetBuffer)[c] += ((Uint16 *)PlayPtr->Buffer)[c + PlayOffset];
			PlayOffset += CopyEnd;

			if((PlayOffset << 1) == PlayPtr->Length)
				PlayPtr = NULL;
		}
		else
		{
			unsigned int CopyEnd = TargetLength;
			if(CopyEnd > PlayPtr->Length-PlayOffset)
				CopyEnd = PlayPtr->Length-PlayOffset;

			for(unsigned int c = 0; c < CopyEnd; c++)
				TargetBuffer[c] += PlayPtr->Buffer[c + PlayOffset];
			PlayOffset += CopyEnd;

			if(PlayOffset == PlayPtr->Length)
				PlayPtr = NULL;
		}
	}
}

void CSoundPlayer::PlaySoundEffect(int ID)
{
	PlayPtr = &Sounds[ID];
	PlayOffset = 0;
}

void CSoundPlayer::InstallSound(int slot, char *name)
{
	SDL_AudioSpec wav_spec;
	SDL_RWops *t = FileStore.GetRWops(name);
	if(SDL_LoadWAV_RW(t, 0, &wav_spec, &Sounds[slot].Buffer, &Sounds[slot].Length))
	{
		SDL_AudioCVT wav_cvt;
		
		SDL_BuildAudioCVT(&wav_cvt,
				wav_spec.format, wav_spec.channels, wav_spec.freq,
				AudioSpec.format, AudioSpec.channels, AudioSpec.freq);

		wav_cvt.buf = (Uint8 *)malloc(Sounds[slot].Length*wav_cvt.len_mult);
		wav_cvt.len = Sounds[slot].Length;
		memcpy(wav_cvt.buf, Sounds[slot].Buffer, Sounds[slot].Length);

		SDL_FreeWAV(Sounds[slot].Buffer);
		SDL_ConvertAudio(&wav_cvt);
		Sounds[slot].Buffer = wav_cvt.buf;
		Sounds[slot].Length = wav_cvt.len_cvt;
	}
	FileStore.ReturnRWops(t);
}
