#ifndef __SCREEN_H
#define __SCREEN_H

#include "AnimatedBitmap.h"
class CDizzy;

class CScreenHandler
{
	public:
		CScreenHandler(bool ForDisplay = true);
		~CScreenHandler();

		bool Open(char *forename, char *backname = NULL, float backmultiple = 0, float addx = 0, float addy = 0);
		bool AddPatch(char *name, int x, int y);

		void Draw(float x, float y);
		void AddEscapeVector(CDizzy &player, float &escx, float &escy, float &energy);
		int QueryScreenChange(float x, float y);
		void FinishTransition(int dir, float &x, float &y);

		void FlushTiles();
		void InitTile(Uint8 id, CBitmap *img, bool coll, bool deadly, bool infront, bool cloud);

		char *GetName();
		void SetName(char *);

	private:
		void DrawLayer(int maskx, int masky, float fardist, float neardist, Uint16 Map[][256]);
		unsigned int XOffset, YOffset;
		float XScroll, YScroll;
		bool AddPatchInternal(char *name, int x, int y, Uint16 Map[][256]);

		Uint16 ForeMap[512][256];
		int MapW, MapH;

		Uint16 BackMap[512][256];
		int BackWMask, BackHMask;
		float BackAddX, BackAddY;
		float BackMultiple;

		bool ForDisplay;

		class Tile
		{
			public:
				CBitmap *Image;
				bool Collidable, Deadly, Infront, Cloud;
		} Tiles[256];
		int PatchEndX, PatchEndY;
		char *Name;
};

#endif
