#include "ScreenHandler.h"
#include "Map.h"
#include <string.h>
#include <math.h>
#include "Depths.h"
#include "HostMachine.h"
#include "TimeKeeper.h"
#include "DizzyState.h"

#define FLAG_COLLIDABLE		0x8000
#define FLAG_DEADLY			0x4000
#define FLAG_INFRONT		0x2000
#define FLAG_CLOUD			0x1000

CScreenHandler::CScreenHandler(bool Disp)
{
	int c = 256;
	while(c--)
		Tiles[c].Image = NULL;
	ForDisplay = Disp;
}

bool CScreenHandler::AddPatchInternal(char *name, int x, int y, Uint16 Map[][256])
{
	FILE *map = host_fopen(name, "rt");
	if(!map) return false;
	int MaxX = 0;
	while(!feof(map))
	{
		Uint8 newc = fgetc(map);

		if(newc >= 32)
		{
			if(ForDisplay)
			{
				if(Tiles[newc].Image)
				{
					Map[x][y] = newc | 
										(Tiles[newc].Collidable ? FLAG_COLLIDABLE : 0) |
										(Tiles[newc].Deadly ? FLAG_DEADLY : 0) |
										(Tiles[newc].Infront ? FLAG_INFRONT : 0) |
										(Tiles[newc].Cloud ? FLAG_CLOUD : 0);
				}
				else
					Map[x][y] = 0;
			}
			else
				Map[x][y] = (newc == ' ') ? 0 : FLAG_COLLIDABLE;
			x++;
		}
		else
		{
			if(newc == '\n') {if(x > MaxX) MaxX = x; x = 0; y++;}
		}
	}

	fclose(map);
	PatchEndX = (x > MaxX) ? x : MaxX;
	PatchEndY = y;
	return true;
}

bool CScreenHandler::AddPatch(char *name, int x, int y)
{
	return AddPatchInternal(name, x, y, ForeMap);
}

bool CScreenHandler::Open(char *forename, char *backname, float backmult, float addx, float addy)
{
	/* clear both layers */
	for(int c = 0; c < 512; c++)
	{
		memset(ForeMap[c], 0, 256);
		memset(BackMap[c], 0, 256);
	}

	/* setup background layer */
	if(ForDisplay)
	{
		BackAddX = addx;
		BackAddY = addy;
		BackMultiple = backmult;
		if(AddPatchInternal(backname, 0, 0, BackMap))
		{
			/* determine mask for background layer */
			int TestMask = PatchEndX-1, TestValue = TestMask >> 1;
			if(TestMask&TestValue == TestValue)
				BackWMask = TestMask;
			else
				BackWMask = 511;

			TestMask = PatchEndY-1;
			TestValue = TestMask >> 1;
			if(TestMask&TestValue == TestValue)
				BackHMask = TestMask;
			else
				BackHMask = 255;
		}
		else
			BackHMask = BackWMask = 0;
	}

	/* load foreground map */
	if(!AddPatch(forename, 0, 0)) return false;

	MapW = PatchEndX;
	MapH = PatchEndY;
	return true;
}

CScreenHandler::~CScreenHandler()
{
	int c = 256;
	while(c--)
		delete Tiles[c].Image;
}

void CScreenHandler::DrawLayer(int maskx, int masky, float fardist, float neardist, Uint16 Map[][256])
{
	glColor3f(1, 1, 1);
	float x = 4-XScroll, y = 4-YScroll;

	for(int ix=0; ix < 41; ix++)
	{
		for(int iy=0; iy < 26; iy++)
		{
			Uint16 MapValue = Map[(ix+XOffset)&maskx][(iy+YOffset)&masky];
			if(MapValue)
				Tiles[MapValue&255].Image->Draw((MapValue&FLAG_INFRONT) ? neardist: fardist, x, y);
			y += 8;
		}
		x += 8;
		y -= 208;
	}
}

void CScreenHandler::Draw(float x, float y)
{
	x -= 160;
	y -= 100;
	if(x < 0) x = 0;
	if(y < 0) y = 0;
	if(x >= (MapW-40)*8) x = (MapW-40)*8;
	if(y >= (MapH-25)*8) y = (MapH-25)*8;

	float BackX = (XScroll + (float)(XOffset << 3) + (float)TimeKeeper.Quantums*BackAddX)*BackMultiple;
	float BackY = (YScroll + (float)(YOffset << 3) + (float)TimeKeeper.Quantums*BackAddY)*BackMultiple;
	XOffset = (int)BackX >> 3; XScroll = BackX - (XOffset << 3);
	YOffset = (int)BackY >> 3; YScroll = BackY - (YOffset << 3);
	DrawLayer(BackWMask, BackHMask, DEPTH_BACKGROUND, DEPTH_BACKGROUND_INFRONT, BackMap);

	XOffset = (int)x >> 3; XScroll = x - (XOffset << 3);
	YOffset = (int)y >> 3; YScroll = y - (YOffset << 3);
	DrawLayer(511, 255, DEPTH_FOREGROUND, DEPTH_FOREGROUND_INFRONT, ForeMap);

	glTranslatef(-XScroll - (XOffset << 3), -YScroll - (YOffset << 3), 0);
}

void CScreenHandler::AddEscapeVector(CDizzy &player, float &escx, float &escy, float &energy)
{
	/* assume these for now */
	int w = 12;
	int h = 22;

	/* figure out which blocks may be affecting */
	int startx = ((int)(player.x -(w >> 1))) >> 3;
	int endx = ((int)(player.x +(w >> 1))) >> 3;

	int starty = ((int)(player.y -(h >> 1))) >> 3;
	int endy = ((int)(player.y +(h >> 1))) >> 3;

	if(startx < 0) startx = 0;
	if(starty < 0) starty = 0;
	if(endx >= MapW) endx = MapW-1;
	if(endy >= MapH) endy = MapH-1;

	for(int iy = starty; iy <= endy; iy++)
		for(int ix = startx; ix <= endx; ix++)
		{
			/* get the centre position of this tile, to make future things easier */
			float CentreX, CentreY;
			CentreX = (float)(ix << 3) + 4.0f;
			CentreY = (float)(iy << 3) + 4.0f;

			if(ForeMap[ix][iy]&FLAG_CLOUD)
			{
				if((player.yadd > 0) && (player.y < (CentreY-4.0f)))
				{
					player.yadd = 0.15f;
					player.OnGround = true;
				}
			}
			else
				if(ForeMap[ix][iy]&FLAG_COLLIDABLE)
				{
					/* okay - a solid collision! But what sort? */

					if((CentreY < player.y) && !(ForeMap[ix][iy+1]&FLAG_COLLIDABLE) && (player.yadd < 0) && (fabs(CentreY-player.y) > fabs(CentreX-player.x)))
						escy = ( (iy << 3) + (h >> 1)+8 )-player.y;
					else
					{
						if((CentreY > player.y) && !(ForeMap[ix][iy-1]&FLAG_COLLIDABLE) && (player.yadd > 0))
						{
							float nescy;
							nescy = ( (iy << 3) - (h >> 1) )-player.y;
							if(nescy < -1) nescy = -1;
							if(nescy < escy) escy = nescy;
						}
						else
						{
							if((CentreX < player.x)) escx = (CentreX + 4) - (player.x - (w >> 1));
							if((CentreX > player.x)) escx = (CentreX - 4) - (player.x + (w >> 1));
						}
					}
				}

			/* is Dizzy overlapping an energy depleting tile? */
			if(ForeMap[ix][iy]&FLAG_DEADLY)
				energy--;
		}
}

int CScreenHandler::QueryScreenChange(float x, float y)
{
	/* assume these for now */
	int w = 12;
	int h = 22;
	
	if(x < (w >> 1)) return DIRECTION_LEFT;
	if(x > (MapW << 3) - (w >> 1)) return DIRECTION_RIGHT;
	if(y < (h >> 1)) return DIRECTION_UP;
	if(y > (MapH << 3) - (h >> 1)) return DIRECTION_DOWN;

	return -1;
}

void CScreenHandler::FinishTransition(int dir, float &x, float &y)
{
	/* assume these for now */
	int w = 12;
	int h = 22;

	switch(dir)
	{
		case DIRECTION_LEFT:	x = (float)((MapW << 3) - (w >> 1)); break;
		case DIRECTION_RIGHT:	x = (float)(w >> 1); break;
		case DIRECTION_UP:		y = (float)((MapH << 3) - (h >> 1)); break;
		case DIRECTION_DOWN:	y = (float)(h >> 1); break;
	}
}

void CScreenHandler::FlushTiles()
{
}

void CScreenHandler::InitTile(Uint8 id, CBitmap *Img, bool coll, bool deadly, bool infront, bool cloud)
{
	if(Tiles[id].Image)
		delete Tiles[id].Image;
	
	Tiles[id].Collidable = coll;
	Tiles[id].Deadly = deadly;
	Tiles[id].Infront = infront;
	Tiles[id].Cloud = cloud;
	Tiles[id].Image = Img;
}

char *CScreenHandler::GetName() { return Name; }
void CScreenHandler::SetName(char *n) { Name = n; }
