#ifndef __MAP_H
#define __MAP_H

#include "ScreenHandler.h"
#include "TextWriter.h"
class CDizzy;

#define DIRECTION_LEFT	0
#define DIRECTION_RIGHT	1
#define DIRECTION_UP	2
#define DIRECTION_DOWN	3

/*

	CONSTITUENTS OF THE WORLD

*/

class FloatingRect
{
	public:
	float x1, y1, x2, y2;
	bool Overlaps(FloatingRect &b);
};

class MapPatch;

class Screen
{
	public:
		Screen();
		~Screen();
		void Read();

		int Id;

		char *ScreenName;
		float R, G, B;

		char *ForegroundMap;
		char *BackgroundMap;
		float BackgroundMultiple;
		float BackScrollX, BackScrollY;

		int ScreenRefs[4];

		Screen *Next;
		MapPatch *Patches;
};

class ScreenLink
{
	public:
		ScreenLink();
		void Read();

		int ScreenRefs[2];
		float AddX, AddY;

		ScreenLink *Next;
};

class MapPatch
{
	public:
		MapPatch();
		~MapPatch();
		void Read();

		int Id;

		int ScreenRef;
		char *Filename;
		int x, y;

		MapPatch *Next, *ScreenNext;
};

class DizzyPatch
{
	public:
		DizzyPatch();
		void Read();

		int Id;

		int ScreenRef;
		float NewX, NewY;

		int Jumping;
		int Direction;

		DizzyPatch *Next;
};

class ObjectDefinition
{
	public:
		ObjectDefinition();
		~ObjectDefinition();
		void Read();

		int Id;

		int JoinFlag;
		int CollisionMode;
		char *Name;
		CScreenHandler *Tilemap;
		CBitmap *Image;

		ObjectDefinition *Next;
};

class Object
{
	public:
		Object();
		~Object();
		void Read(ObjectDefinition *DefList);
		void CalculateCorrectXY();
		void CalculateBounder();

		int Id;

		int ScreenRef;

		/* movement list */
		unsigned int TotalTime;
		class Node
		{
			public:
				Node();
				void Read();

				float x, y;
				int MirrorMode;
				unsigned int Time;
				Node *Next;
		} *Path, *CPtr;
		unsigned int BaseTime;
		void LoadPath();
		void FreePath();

		int BehindFlag;

		ObjectDefinition *Definition;
		Object *Next, *ScreenNext;

		float CurrentX, CurrentY;
		int CurrentMirrorMode;
		FloatingRect Bounder;
		Uint32 CurrentQuantum;
};

class ObjectPatch
{
	public:
		ObjectPatch();
		void Read();

		int Id;

		int ObjectRef;
		int ScreenRef;
		int ObjectSubstitution;

		ObjectPatch *Next;
};

enum EventTypes {ET_ACTION, ET_WALKOVER};
class Event
{
	public:
		Event();
		~Event();
		void Read();

		int ObjectRefs[2];
		EventTypes Type;
		int ObjectUseFlag, OneTimeFlag;

		int MapPatchRef;
		int ObjectPatchRef;
		int DizzyPatchRef;
		char *DialogueSource;

		Uint16 Key;
		Event *Next, *QueueNext;
};

/*

	HANDLERS FOR THE ABOVE

*/

class CDialogueHandler
{
	public:
		CDialogueHandler();
		~CDialogueHandler();
		void PickLocation(CTextWriter *Writer);
		bool Open(char *name);

		FloatingRect Position;
		char *Text;
		float r, g, b;
		CDialogueHandler *Next;
};

#define	CMC_OBJECT		1
#define	CMC_DIALOGUE	2
extern Uint16 GetEventKey(int Id1, int Id2);

class CMap
{
	public:
		bool Open(char *name);
		void FreeStructures();
		~CMap();
		CMap();

		// this one starts the level off
		void GetInitialScreen(CDizzy &player);

		// draws all objects/Objects allocated to the current room
		void AddObjects();
		
		// stuff for interaction with Objects - returns bitflags indicating important changes
		int ProcessPosition(CDizzy &player, float &escx, float &escy, float &energy);

	private:
		// stuff for interaction with objects
		void PutObject(Object *, CDizzy &player);
		bool EnactEvent(Event *, CDizzy &);
		Event *GetEvent(int Id1, int Id2, EventTypes category);

		void SortObjects();

		/* Things that make up the entire map */
		Screen *ScreenList;
		ScreenLink *ScreenLinkList;
		MapPatch *MapPatchList;
		DizzyPatch *DizzyPatchList;
		ObjectDefinition *ObjectDefinitionList;
		Object *ObjectList;
		ObjectPatch *ObjectPatchList;
		Event *EventList[65536]; /* works as a sort of hash table */

		/* Things in use transiently */
		CScreenHandler *CurrentScreen;
		Screen *ScreenPtr;
		ScreenLink *ScreenLinkPtr;
		Object *ScreenObjectList;

		/* Internal functions for various loading things */
		void LoadTiles();
		void LoadScreenList();
		void LoadScreenLinkList();
		void LoadDizzyPatches();
		void LoadMapPatches();
		void LoadObjectDefinitions();
		void LoadObjects();
		void LoadObjectPatches();
		void LoadEvents();

		void LoadInitialStats();

		// this one moves from one screen to the next
		void ChangeScreen(int Direction, CDizzy &player);

		/* Initial positioning information */
		int StartScreen;
		float StartX, StartY;

		/* Misc internal functions */
		CScreenHandler *GetScreen(int id);
		void GetScreenLink(int id1, int id2);

		void MakeScreenLists();
};

#endif
