#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "SDL.h"
#include "SDL_opengl.h"
#include "BitmapManager.h"
#include "TimeKeeper.h"
#include "AnimatedBitmap.h"
#include "ScreenHandler.h"
#include "Map.h"
#include "Sound.h"
#include "TextWriter.h"
#include "DisplaySetup.h"
#include "DizzyState.h"
#include "HostMachine.h"
#include "BitmapRepository.h"

#define BeginHotSpot(eq)\
	if(Text = Map->GetDialogue(eq))\
		{Text->PickLocation(Writer); TriggeredHotSpot = eq;}\
	else\
		Screen = Map->EnactHotSpot(eq, Dizzy)

bool Fullscreen = true, FirstToggle = true;
void ToggleFullscreen()
{
	GLfloat ClearColour[4];
	if(!FirstToggle)
		glGetFloatv(GL_COLOR_CLEAR_VALUE, ClearColour);

	BitmapRepository.Backup();
	SetGFXMode(640, 480, Fullscreen = !Fullscreen);

	if(!FirstToggle)
		glClearColor(ClearColour[0], ClearColour[1], ClearColour[2], ClearColour[3]);
	FirstToggle = false;
}

int main(int argc, char *argv[])
{
	bool Quit = false;

	CDizzy Dizzy;

	CTextWriter *Writer;
	CMap *Map;
	bool Oldret = false;

	char *NewObjectName = NULL;
	Uint32 NewObjectStartTime = 0;

	// Init SDL video subsystem
	if ( SDL_Init (SDL_INIT_VIDEO|SDL_INIT_AUDIO) < 0 ) {
        fprintf(stderr, "Couldn't initialize SDL: %s\n",
			SDL_GetError());
		exit(1);
	}

	ToggleFullscreen();
	SetupHostMachine();
	BitmapManager = new CBitmapParent;

	Map = new CMap;
	Map->Open("world.txt");
	Dizzy.LoadSprites();

	Map->GetInitialScreen(Dizzy);

	/* start the music */
	SoundPlayer = new CSoundPlayer;
	SoundPlayer->StartFile("Magicdiz.mod");

	printf("Result is %d\n", 4 & 1 ? 2 : 3 != 0 ? 99 : 98);

	/* text writer */
	Writer = new CTextWriter;

	while(!Quit)
	{
		TimeKeeper.Tick();

		Uint8 *Keys = SDL_GetKeyState(NULL);
		if(!Dizzy.CurrentDialogue)
		{
			/* update physics */
			if(Dizzy.Jumping)
			{
				Dizzy.Jumping--;
				if(!Dizzy.Jumping && !Dizzy.OnGround) Dizzy.Jumping = 32;
			}

			/* check how player moves */
			Dizzy.Interacting = false;
			if(!Dizzy.Jumping && Dizzy.OnGround)
			{
				Dizzy.Direction  = 0;
				if(Keys[SDLK_x]) Dizzy.Direction = 1;
				if(Keys[SDLK_z]) Dizzy.Direction = -1;
				if(Keys[SDLK_SPACE]) Dizzy.StartJump();
				if(Keys[SDLK_RETURN] && !Oldret) Dizzy.Interacting = true;
			}

			/* motion */
			Dizzy.x += Dizzy.Direction;
			Dizzy.AddGravity();
			Dizzy.y += Dizzy.yadd;

			/* check for map collisions */
			float ex = 0, ey = 0, energy = 0;
			Dizzy.OnGround = false;
			int Adjustments = Map->ProcessPosition(Dizzy, ex, ey, energy);
			Dizzy.Energy += energy;

			if(ey < 0) {Dizzy.yadd = 0.0f; Dizzy.OnGround= true;}
			Dizzy.x += ex; Dizzy.y += ey;
			Dizzy.CalculateBoundingBox();

			if(Adjustments&CMC_OBJECT)
			{
				NewObjectStartTime = NewObjectName ? TimeKeeper.Quantums-50 : TimeKeeper.Quantums;
				int c = 5;
				while(c--)
				{
					if(Dizzy.Objects[c])
					{
						NewObjectName = Dizzy.Objects[c]->Definition->Name;
						break;
					}
				}
			}
			if(Adjustments&CMC_DIALOGUE)
				Dizzy.CurrentDialogue->PickLocation(Writer);
		}
		else
		{
			if(Keys[SDLK_RETURN] && !Oldret)
			{
				CDialogueHandler *Next = Dizzy.CurrentDialogue->Next;
				delete Dizzy.CurrentDialogue;
				Dizzy.CurrentDialogue = Next;
				if(Dizzy.CurrentDialogue)
					Dizzy.CurrentDialogue->PickLocation(Writer);
			}
		}
		Oldret = Keys[SDLK_RETURN] ? true : false;

		/* DRAWING */
			if(!TimeKeeper.FrameSkip)
			{
				/* draw status */
				glScissor(0, 0, screen->w, (screen->h*40)/240);
				
				float texx = 160.0f - Writer->GetLength(Dizzy.Screen->GetName()) * 0.5f;
				if(NewObjectName) 
				{
					float ntexx = 160.0f - Writer->GetLength("You collected %s", NewObjectName) * 0.5f;
					Uint32 Offset = TimeKeeper.Quantums - NewObjectStartTime;
					if(Offset < 50)
					{
						float Ratio = (float)Offset / 50.0f;
					
						glColor4f(1.0f, 1.0f, 1.0f, 1.0f - Ratio);
						Writer->Write(texx, 232, 320, 8, Dizzy.Screen->GetName());

						glColor4f(1.0f, 1.0f, 1.0f, Ratio);
						Writer->Write(ntexx, 232, 320, 8, "You collected %s", NewObjectName);
					}
					else
						if(Offset < 200)
						{
							glColor3f(1.0f, 1.0f, 1.0f);
							Writer->Write(ntexx, 232, 320, 8, "You collected %s", NewObjectName);
						}
						else
						{
							float Ratio = (float)(250.0f - Offset) / 50.0f;

							glColor4f(1.0f, 1.0f, 1.0f, Ratio);
							Writer->Write(ntexx, 232, 320, 8, "You collected %s", NewObjectName);

							glColor4f(1.0f, 1.0f, 1.0f, 1.0f - Ratio);
							Writer->Write(texx, 232, 320, 8, Dizzy.Screen->GetName());

							if(Offset >= 250)
								NewObjectName = NULL;
						}
				}
				else
				{
					glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
					Writer->Write(texx, 232, 320, 8, Dizzy.Screen->GetName());
				}

				glColor4f(1, 1, 1, 1);
				Writer->Write(0, 200, 320, 8, "%0.2f - %0.2f %0.2f", Dizzy.Energy, Dizzy.x, Dizzy.y);

				BitmapManager->Activate();
				glPushMatrix();

					glTranslatef(320.0f/6.0f, 220, 0);
					int c = 5;
					while(c--)
					{
						if(Dizzy.Objects[c])
							Dizzy.Objects[c]->Definition->Image->Draw();
						glTranslatef(320.0f/6.0f, 0, 0);
					}

				glPopMatrix();

				/* draw map */
				glScissor(0, (screen->h*40)/240, screen->w, (screen->h*200)/240);
				glPushMatrix();

					Dizzy.Screen->Draw(Dizzy.x, Dizzy.y);
					Map->AddObjects();

					if(Dizzy.CurrentDialogue) Dizzy.Direction = 0;
					Dizzy.Draw();

				glPopMatrix();

				/* draw current text dialogue if relevant */
				if(Dizzy.CurrentDialogue)
				{
					glColor3f(0, 0, 0);
					glDisable(GL_TEXTURE_2D);
					glBegin(GL_QUADS);
						glVertex2f(Dizzy.CurrentDialogue->Position.x1, Dizzy.CurrentDialogue->Position.y1);
						glVertex2f(Dizzy.CurrentDialogue->Position.x2, Dizzy.CurrentDialogue->Position.y1);
						glVertex2f(Dizzy.CurrentDialogue->Position.x2, Dizzy.CurrentDialogue->Position.y2);
						glVertex2f(Dizzy.CurrentDialogue->Position.x1, Dizzy.CurrentDialogue->Position.y2);
					glEnd();
					glEnable(GL_TEXTURE_2D);
					glColor3f(Dizzy.CurrentDialogue->r, Dizzy.CurrentDialogue->g, Dizzy.CurrentDialogue->b);
					Writer->Write(Dizzy.CurrentDialogue->Position.x1+2, Dizzy.CurrentDialogue->Position.y1+2, Dizzy.CurrentDialogue->Position.x2-2, Dizzy.CurrentDialogue->Position.y2-2, Dizzy.CurrentDialogue->Text);
				}

				/* put license on top if necessary */
				if(TimeKeeper.Quantums < 400)
				{
					glColor4f(1, 1, 1, (TimeKeeper.Quantums < 300) ? 1 : ((400.0f - TimeKeeper.Quantums) / 100.0f));
					Writer->Write(0, 0, 320, 240, "\"Dizzy\", \"The Yolkfolk\" and all related characters and titles are trademarks of Blitz Games Limited (\"Blitz\") and The Codemasters Software Company Limited (\"Codemasters\"). All rights reserved. Dizzy and The Yolkfolk created by The Oliver Twins.");
				}

				/* switch buffers, clear new buffer */
				glScissor(0, 0, screen->w, screen->h);
				SDL_GL_SwapBuffers();
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			}

		/* handle SDL events */
		SDL_Event Event;
		while(SDL_PollEvent(&Event))
		{
			switch(Event.type)
			{
				case SDL_QUIT: Quit = true; break;

				case SDL_KEYDOWN:
					/* MacOS style key shortcuts */
					if(Event.key.keysym.mod&KMOD_META)
						switch(Event.key.keysym.sym)
						{
							default: break;
							case SDLK_q: Quit = true; break;
							case SDLK_f: ToggleFullscreen(); break;
						}

					/* Windows style key shortcuts */
					if(Event.key.keysym.mod&(KMOD_LALT|KMOD_RALT))
					{
						switch(Event.key.keysym.sym)
						{
							case SDLK_F4: Quit = true; break;
							case SDLK_RETURN: ToggleFullscreen(); break;
							default: break;
						}
					}
				break;
			}
		}
	}

    // Cleanup
	delete Writer;
	delete SoundPlayer;
	delete BitmapManager;
	delete Map;
	SDL_Quit();

    return 0;
}
