#import <Cocoa/Cocoa.h>
#include "HostMachine.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

NSAutoreleasePool * autoreleasepool;
NSString *resourcesPath;

void CloseHostMachine()
{
	[autoreleasepool release];
}

void SetupHostMachine()
{
	autoreleasepool = [[NSAutoreleasePool alloc] init];
	resourcesPath = [NSString stringWithFormat:@"%@/Contents/Resources", [[NSBundle mainBundle] bundlePath] ];
	atexit(CloseHostMachine);
}

char DirectorySeparatorChar()
{
	return '/';
}

void DisplayError(char * fmt, ... )
{
	va_list Arguments;
	
	va_start(Arguments, fmt);
	// Make an NSString with the error message formatted.
	NSString * msg = [[[NSString alloc] initWithFormat:[NSString stringWithCString:fmt] arguments:Arguments] autorelease];
	va_end(Arguments);

	// Show the alert
	NSAlert *alert = [ [ NSAlert alloc ] init ];
	[ alert addButtonWithTitle:@"OK" ];
	[ alert setMessageText:@"Error" ];
	[ alert setInformativeText:msg ];
    [ alert setAlertStyle: NSCriticalAlertStyle ];
    [ alert runModal ];
	[ alert release ];
	[ msg release ];

	// Log message to stderr.
	NSLog( msg );
}

const char *GetResourcePath()
{
	return  [resourcesPath cString];
}

char SeparatorChar()
{
	return '/';
}
