#ifndef __DIZZYSTATE_H
#define __DIZZYSTATE_H

#include "AnimatedBitmap.h"
#include "Map.h"

/* just in case two player simultaneous play should become an idea */
class CDizzy
{
	public:
		CDizzy();
		~CDizzy();

		bool LoadSprites();
		void Draw();
		void DoInput();
		void StartJump();
		void AddGravity();
		void ShiftObjects(int startid);
		CBitmap *GetImage(int &DirFlags);
		void CalculateBoundingBox();

		float x, y, Energy, yadd;
		int Lives;
		int Direction;
		int Jumping;
		bool OnGround, Interacting;
		Object *Objects[5];
		FloatingRect Bounder;
		
		CScreenHandler *Screen;
		Event *TriggeredEvent;
		CDialogueHandler *CurrentDialogue;

	private:
		CRegularBitmap *Bounce;
		CRegularBitmap *Walk;
		CRegularBitmap *JumpUp;
		CRegularBitmap *JumpSide;
		CRegularBitmap *Pickup;
		CRegularBitmap *Death;
};

#endif
