#include "DizzyState.h"
#include "SDL_opengl.h"
#include "Depths.h"
#include "Sound.h"

#define FULL_ENERGY	32.0f

CDizzy::CDizzy()
{
	Bounce = Walk = JumpUp = JumpSide = Pickup = Death = NULL;
	Lives = 3;
	Energy = FULL_ENERGY;
	Objects[0] = Objects[1] = Objects[2] = Objects[3] = Objects[4] = NULL;

	Jumping = 0;
	Direction = 0;
	OnGround = false;
	Interacting = false;
	yadd = 0;

	TriggeredEvent = NULL;
	CurrentDialogue = NULL;
	Screen = NULL;
}

CDizzy::~CDizzy()
{
	delete Bounce;
	delete Walk;
	delete JumpUp;
	delete JumpSide;
	delete Pickup;
	delete Death;
}

bool CDizzy::LoadSprites()
{
	bool Failed = false;

	Bounce = new CRegularBitmap(BitmapManager, 2, 5, true);
	Walk = new CRegularBitmap(BitmapManager, 8, 5, true);
	JumpUp = new CRegularBitmap(BitmapManager, 8, 4, true);
	JumpSide = new CRegularBitmap(BitmapManager, 8, 4, true);

	/* set up the bounce */
	Failed |= !Bounce->SetFrameImage(0, "b1.png");
	Failed |= !Bounce->SetFrameImage(1, "b2.png");
	
	/* set up the walk */
	Failed |= !Walk->SetFrameImage(0, "w0.png");
	Failed |= !Walk->SetFrameImage(1, "w1.png");
	Failed |= !Walk->SetFrameImage(2, "w2.png");
	Failed |= !Walk->SetFrameImage(3, "w3.png");
	Failed |= !Walk->SetFrameImage(4, "w4.png");
	Failed |= !Walk->SetFrameImage(5, "w5.png");
	Failed |= !Walk->SetFrameImage(6, "w6.png");
	Failed |= !Walk->SetFrameImage(7, "w7.png");

	/* set up the jump upwards */
	Failed |= !JumpUp->SetFrameImage(0, "j7.png");
	Failed |= !JumpUp->SetFrameImage(1, "j6.png");
	Failed |= !JumpUp->SetFrameImage(2, "j5.png");
	Failed |= !JumpUp->SetFrameImage(3, "j4.png");
	Failed |= !JumpUp->SetFrameImage(4, "j3.png");
	Failed |= !JumpUp->SetFrameImage(5, "j2.png");
	Failed |= !JumpUp->SetFrameImage(6, "j1.png");
	Failed |= !JumpUp->SetFrameImage(7, "j0.png");

	/* set up the jump sideways */
	Failed |= !JumpSide->SetFrameImage(0, "s0.png");
	Failed |= !JumpSide->SetFrameImage(1, "s1.png");
	Failed |= !JumpSide->SetFrameImage(2, "s2.png");
	Failed |= !JumpSide->SetFrameImage(3, "s3.png");
	Failed |= !JumpSide->SetFrameImage(4, "s4.png");
	Failed |= !JumpSide->SetFrameImage(5, "s5.png");
	Failed |= !JumpSide->SetFrameImage(6, "s6.png");
	Failed |= !JumpSide->SetFrameImage(7, "s7.png");

	return !Failed;
}

CBitmap *CDizzy::GetImage(int &MirrorMode)
{
	if(Jumping)
	{
		switch(Direction)
		{
			case 0:		MirrorMode = 0;						return JumpUp;
			case -1:	MirrorMode = DIRFLAG_REVERSE_X;		return JumpSide;
			case 1:		MirrorMode = 0;						return JumpSide;
		}
	}
	else
		switch(Direction)
		{
			case 0:		MirrorMode = 0;						return Bounce;
			case -1:	MirrorMode = DIRFLAG_REVERSE_X;		return Walk;
			case 1:		MirrorMode = 0;						return Walk;
		}

	return NULL;
}

void CDizzy::Draw()
{
	int FlipMode;
	CBitmap *Img = GetImage(FlipMode);

	glPushMatrix();
		glColor3f(1, 1, 1);
		glTranslatef(x, y, DEPTH_DIZZY);

		if(FlipMode) glScalef(-1, 1, 1);
		Img->Draw();
	glPopMatrix();
}

void CDizzy::StartJump()
{
	Jumping = 64;
	yadd = -2.0f;
	JumpUp->SetFrame(0);
	JumpSide->SetFrame(0);
	SoundPlayer->PlaySoundEffect(SND_JUMP);
}

void CDizzy::AddGravity()
{
	yadd += 16.0f / 256.0f;
	if(yadd > 3.9f) yadd = 3.9f;
}

void CDizzy::ShiftObjects(int startid)
{
	while(startid < 4)
	{
		Objects[startid] = Objects[startid+1];
		startid++;
	}
	Objects[4] = NULL;
}

/*bool CDizzy::Overlaps(float x1, float y1, float x2, float y2)
{
	int t;
	float w, h;
	
	w = GetImage(t)->GetW()*0.5f;
	h = GetImage(t)->GetH()*0.5f;
	if(x2 < x-w) return false;
	if(x1 > x+w) return false;
	if(y2 < y-h) return false;
	if(y1 > y+h) return false;
	return true;
}*/

void CDizzy::CalculateBoundingBox()
{
	int t;
	float w, h;
	
	w = GetImage(t)->GetW()*0.5f;
	h = GetImage(t)->GetH()*0.5f;
	
	Bounder.x1 = x-w; Bounder.x2 = x+w;
	Bounder.y1 = y-h; Bounder.y2 = y+h;
}
