#include "DisplaySetup.h"
#include "SDL_opengl.h"

SDL_Surface *screen;
bool SetGFXMode(int w, int h, bool fullscreen)
{
    // Request 16bit depth buffer, double buffering - don't care about colour depth
    SDL_GL_SetAttribute (SDL_GL_DEPTH_SIZE, 16);
    SDL_GL_SetAttribute (SDL_GL_DOUBLEBUFFER, 1);

    // Create window
    if (!(screen = SDL_SetVideoMode (w, h, 0, SDL_OPENGL | (fullscreen ? SDL_FULLSCREEN : 0))))
		return false;

	//immediately clear to black
	glClearColor(0, 0, 0, 0);
	glClear(GL_COLOR_BUFFER_BIT);
	SDL_GL_SwapBuffers();

	// set up expected viewport of (0, 0) -> (320, 240), deeper = positive z, scissor mode on, modelview identity
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, 320, 240, 0, 0, 32);
	glScalef(1, 1, -1);
	glTranslatef(0, 0, 1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glEnable(GL_SCISSOR_TEST);

	glClearDepth(1.0f);
	glDepthFunc(GL_LEQUAL);
	glEnable(GL_DEPTH_TEST);
	glAlphaFunc(GL_NOTEQUAL, 0);
	glEnable(GL_ALPHA_TEST);

	return true;
}
