#include "BitmapRepository.h"
#include "BitmapManager.h"

CBitmapRepository BitmapRepository;

CBitmapRepository::CBitmapRepository() { CBPTree = NULL; }

CBitmapRepository::~CBitmapRepository()
{
	while(CBPTree)
	{
		CBPHolder *Next = CBPTree->Next;
		delete CBPTree;
		CBPTree = Next;
	}
}

void CBitmapRepository::Backup()
{
	CBPHolder *P = CBPTree;
	while(P)
	{
		P->Data->Backup();
		P = P->Next;
	}
}

void CBitmapRepository::Add(CBitmapParent *BP)
{
	CBPHolder *N = new CBPHolder;
	N->Data = BP;
	N->Next = CBPTree;
	CBPTree = N;
}

void CBitmapRepository::Remove(CBitmapParent *BP)
{
	if(CBPTree->Data == BP)
	{
		CBPHolder *Next = CBPTree->Next;
		delete CBPTree;
		CBPTree = Next;
		return;
	}

	CBPHolder *P = CBPTree;
	while(P->Next->Data != BP)
		P = P->Next;

	CBPHolder *Next = CBPTree->Next->Next;
	delete CBPTree->Next;
	CBPTree->Next = Next;
}
