#ifndef __BITMAPMANAGER_H
#define __BITMAPMANAGER_H

#include "SDL_opengl.h"
#include "SDL.h"

class CBitmapParent;

#define DIRFLAG_REVERSE_X	1
#define DIRFLAG_REVERSE_Y	2

class CBitmap
{
	protected:
		friend class CBitmapParent;
		float w, h, x1, y1, x2, y2;
		CBitmapParent *BParent;

	public:
		class BitMask
		{
			public:
			BitMask() {ForwardMask = BackwardMask = NULL;}
			~BitMask() {delete[] ForwardMask; delete[] BackwardMask;}
			int BitW, TrueW, H;
			Uint32 *ForwardMask, *BackwardMask;
		} Mask;
		virtual BitMask *GetBitMask();
		virtual ~CBitmap();
		virtual void Draw(float Depth = 0.0f, float x = 0.0f, float y = 0.0f);
		virtual float GetW();
		virtual float GetH();

		virtual bool CheckCollision(CBitmap *other, float offx, float offy, int DirFlags1, int DirFlags2);
};

class CBitmapParent
{
	public:
		void Backup();
		void Activate();
		CBitmap *GetResource(char *name, bool bitmask = false);

		CBitmapParent(int w = 512, int h = 512);
		~CBitmapParent();
	private:
		GLuint TexNum;
		int TexW, TexH;
		int CX, CY, LineHeight;
		bool TextureDirty;
		Uint32 *Bitmap;

		static GLuint CTexNum;
		void SetParameters();
};

extern CBitmapParent *BitmapManager;

#endif
