#ifndef __ARCHIVE_H
#define __ARCHIVE_H

#include "SDL.h"
#include "zlib.h"

class CArchive
{
	public:
		CArchive();
		~CArchive();
		
		SDL_RWops *GetRWops(char *name);
		void ReturnRWops(SDL_RWops *);

		gzFile GetGZFilePtr(char *name);
		void ReturnGZFilePtr(gzFile);

	private:
		gzFile afile;
		unsigned int Offsets[64];
		unsigned int Counts[64];

		Uint8 *Data;
		Uint32 Length;

		void ArchiveFile(char *name);
		bool Find(char *name);
		void OpenFile();
};

extern CArchive FileStore;

#endif
