#ifndef __ANIMATED_BITMAP_H
#define __ANIMATED_BITMAP_H

#include "BitmapManager.h"

class CAnimatedBase: public CBitmap
{
	public:
		virtual ~CAnimatedBase();

		virtual void SetFrame(unsigned int) = 0;
		virtual void Draw(float Depth = 0.0f, float x = 0.0f, float y = 0.0f);
		virtual float GetH();
		virtual float GetW();

		virtual bool CheckCollision(CBitmap *other, float offx, float offy, int Flags1, int Flags2);

	protected:
		virtual BitMask *GetBitMask();
		CBitmapParent *BParent;
		CBitmap **frames;
		virtual CBitmap *CurrentFrame() = 0;
		unsigned int BaseTime, NumFrames;
		bool ObtainBitMask;

		void Setup(CBitmapParent *BParent, int framecount);
};

class CRegularBitmap: public CAnimatedBase
{
	public:
		CRegularBitmap(CBitmapParent *BParent, int framecount, int step, bool bitmask = false);

		bool SetFrameImage(int, char *);
		void SetFrame(unsigned int);

	private:
		unsigned int Divider;
		CBitmap *CurrentFrame();
};

class CIrregularBitmap: public CAnimatedBase
{
	public:
		CIrregularBitmap(CBitmapParent *BParent, int framecount, bool bitmask = false);

		bool SetFrameImage(int frameno, char *, int pause);
		void SetFrame(unsigned int);

	private:
		unsigned int *Times, TotalTime;
		CBitmap *CurrentFrame();
};

#endif
