#include "AnimatedBitmap.h"
#include "TimeKeeper.h"

/*

	Base class

*/

void CAnimatedBase::Setup(CBitmapParent *BP, int framecount)
{
	BParent = BP;
	BaseTime = 0;
	frames = new CBitmap *[NumFrames = framecount];
	while(framecount--)
		frames[framecount] = NULL;
}

CAnimatedBase::~CAnimatedBase()
{
	while(NumFrames--)
		delete frames[NumFrames];
	delete frames;
	frames = NULL;
}
void CAnimatedBase::Draw(float Depth, float x, float y)	{ CurrentFrame()->Draw(Depth, x, y); }
float CAnimatedBase::GetH()				{ return CurrentFrame()->GetH(); }
float CAnimatedBase::GetW()				{ return CurrentFrame()->GetW(); }

bool CAnimatedBase::CheckCollision(CBitmap *other, float offx, float offy, int F1, int F2) { return CurrentFrame()->CheckCollision(other, offx, offy, F1, F2); }
CBitmap::BitMask *CAnimatedBase::GetBitMask() { return CurrentFrame()->GetBitMask(); }

/*

	Regular bitmap

*/

CRegularBitmap::CRegularBitmap(CBitmapParent *p, int framecount, int step, bool bitmask)
{
	Setup(p, framecount);
	Divider = step ? step : 1;
	ObtainBitMask = bitmask;
}

bool CRegularBitmap::SetFrameImage(int frame, char *resname)
{
	frames[frame] = BParent->GetResource(resname, ObtainBitMask);
	return frames[frame] ? true : false;
}

CBitmap *CRegularBitmap::CurrentFrame()
{
	return frames[ ((TimeKeeper.Quantums - BaseTime)/Divider)%NumFrames ];
}

void CRegularBitmap::SetFrame(unsigned int framec)
{
	BaseTime = TimeKeeper.Quantums - framec*Divider;
}

/*

	Irregular bitmap

*/

CIrregularBitmap::CIrregularBitmap(CBitmapParent *BP, int framecount, bool bitmask)
{
	Setup(BP, framecount);
	Times = new unsigned int[NumFrames];
	ObtainBitMask = bitmask;
}

bool CIrregularBitmap::SetFrameImage(int frameno, char *resname, int pause)
{
	Times[frameno] = pause;

	int c = NumFrames;
	TotalTime = 0;
	while(c--)
		TotalTime += Times[c];

	frames[frameno] = BParent->GetResource(resname, ObtainBitMask);
	return frames[frameno] ? true : false;
}

void CIrregularBitmap::SetFrame(unsigned int)
{
}

CBitmap *CIrregularBitmap::CurrentFrame()
{
	unsigned int Offset = (TimeKeeper.Quantums - BaseTime)%TotalTime;
	for(unsigned int c = 0; c < NumFrames; c++)
	{
		if(Offset < Times[c]) return frames[c];
		Offset -= Times[c];
	}
		
	return NULL;
}
